/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.nhm.eui.FileListCanvas;
import ibm.nways.nhm.eui.MyFilenameFilter;
import ibm.nways.nhm.eui.SimpleTextDialog;
import ibm.nways.nhm.file_server.FileInfo;
import ibm.nways.nhm.file_server.RemoteDirectory;
import ibm.nways.ras.Traces;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ResourceBundle;
import java.util.Vector;

public class FileListPanel
extends Panel
implements ActionListener,
ItemListener {
    private Button newFolder;
    private FileListCanvas fileCanvas;
    private TextField efFileName;
    private String serverHost;
    private String upOneLevelString;
    private MyFilenameFilter fnFilter;
    private int serverPort;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");
    private RemoteDirectory rDir;
    private Frame parentFrame;
    private String currentDirectory;
    private String topLevelDirectory;
    public static String STANDARD_HEADER_NAME = "standard_header.html";
    public static String STANDARD_TRAILER_NAME = "standard_trailer.html";
    public static String REPORT_CATALOG_NAME = "ReportCatalog.html";
    public static String IMAGE_DIR_NAME = "images";

    public FileListPanel(Image image, Image image2, Image image3, String string, String string2, MyFilenameFilter myFilenameFilter, Frame frame, int n) {
        super(new BorderLayout());
        this.serverHost = string;
        this.topLevelDirectory = string2;
        this.currentDirectory = string2;
        this.fnFilter = myFilenameFilter;
        this.parentFrame = frame;
        this.upOneLevelString = this.nhmRes.getString("s_upOne");
        this.serverPort = n;
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setSize(350, 150);
        this.fileCanvas = new FileListCanvas(image2, image, image3, this.upOneLevelString);
        this.fileCanvas.setFileNames(this.getFileNames(false));
        scrollPane.add(this.fileCanvas);
        this.fileCanvas.addItemListener(this);
        this.fileCanvas.addActionListener(this);
        this.add("Center", scrollPane);
        Panel panel = new Panel();
        panel.add(new Label(this.nhmRes.getString("s_Name")));
        this.efFileName = new TextField(25);
        panel.add(this.efFileName);
        this.add("South", panel);
    }

    public void requestFocus() {
        this.efFileName.requestFocus();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            ((TextComponent)this.efFileName).setText((String)itemEvent.getItem());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileInfo fileInfo;
        if (actionEvent.getSource() == this.newFolder) {
            String string = this.promptForNewFolderName();
            if (string != null && string.length() > 0) {
                try {
                    this.rDir.createDirectory(string);
                    this.fileCanvas.newFolder(string);
                    return;
                }
                catch (Exception exception) {
                    Traces.logException(exception);
                    return;
                }
            }
        } else if (actionEvent.getSource() == this.fileCanvas && (fileInfo = (FileInfo)this.fileCanvas.getSelectedObjects()[0]).isDirectory()) {
            if (this.upOneLevelString.equals(fileInfo.getName())) {
                this.rDir = null;
                this.currentDirectory = this.currentDirectory.substring(0, this.currentDirectory.lastIndexOf(File.separator));
                Vector vector = this.getFileNames(false);
                if (!this.topLevelDirectory.equals(this.currentDirectory)) {
                    FileInfo fileInfo2 = new FileInfo(this.upOneLevelString, true);
                    vector.insertElementAt(fileInfo2, 0);
                }
                this.fileCanvas.setFileNames(vector);
            } else {
                this.rDir = null;
                this.currentDirectory = String.valueOf(this.currentDirectory) + File.separator;
                this.currentDirectory = String.valueOf(this.currentDirectory) + fileInfo.getName();
                Vector vector = this.getFileNames(false);
                FileInfo fileInfo3 = new FileInfo(this.upOneLevelString, true);
                vector.insertElementAt(fileInfo3, 0);
                this.fileCanvas.setFileNames(vector);
            }
            ((TextComponent)this.efFileName).setText("");
        }
    }

    public String getSelectedFile() {
        String string = "";
        if (this.currentDirectory.length() > this.topLevelDirectory.length()) {
            string = this.currentDirectory.substring(this.topLevelDirectory.length() + 1);
            string = string.concat(File.separator);
        }
        string = string.concat(this.efFileName.getText());
        string = string.replace(' ', '_');
        return string;
    }

    public void setFileName(String string) {
        ((TextComponent)this.efFileName).setText(string);
    }

    private Vector getFileNames(boolean bl) {
        Vector vector = null;
        try {
            this.rDir = new RemoteDirectory(this.currentDirectory, this.serverHost, this.serverPort);
            vector = this.rDir.list((FilenameFilter)this.fnFilter, true);
        }
        catch (Exception exception) {
            Traces.logError(this, "Exception received trying to list reports");
            Traces.logException(exception);
        }
        if (vector != null && !bl) {
            int n = 0;
            while (n < vector.size()) {
                boolean bl2 = false;
                FileInfo fileInfo = (FileInfo)vector.elementAt(n);
                if (this.topLevelDirectory.equals(this.currentDirectory) && (!fileInfo.isDirectory() && (STANDARD_HEADER_NAME.equals(fileInfo.getName()) || STANDARD_TRAILER_NAME.equals(fileInfo.getName()) || REPORT_CATALOG_NAME.equals(fileInfo.getName())) || fileInfo.isDirectory() && IMAGE_DIR_NAME.equals(fileInfo.getName()))) {
                    vector.removeElementAt(n);
                    --n;
                    bl2 = true;
                }
                if (!bl2 && !fileInfo.isDirectory()) {
                    fileInfo.setName(fileInfo.getName().substring(0, fileInfo.getName().length() - this.fnFilter.getExtensionLength()));
                }
                ++n;
            }
        }
        return vector;
    }

    private String promptForNewFolderName() {
        String string = null;
        SimpleTextDialog simpleTextDialog = new SimpleTextDialog(this.parentFrame, this.nhmRes.getString("s_newFolderName"), 25);
        simpleTextDialog.show();
        if (simpleTextDialog.getResult() == 1) {
            string = simpleTextDialog.getString();
        }
        return string;
    }
}

